    <?php 
        /**
        *
        * copyright (c) 2013-2021 Heliac Technologies
        * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
        *
        * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
        */
    ?>

    <div id="benvenuto" class="card shadow border-0 mb-4">
        <div class="card-header">
            <h5 class="my-2"><b>Complimenti!</b> Hai appena installato Geecom CMS! Ecco alcuni suggerimenti per iniziare.</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-4 col-xl-3 mb-3 mb-md-0 d-flex align-items-center text-center border-right">
                    <div class="text-center mx-auto">
                        <img class="img-fluid w-75" src="../template/img/razzo.png">
                    </div>
                </div>
                <div class="col-md-8 col-xl-9 d-flex">
                        <div id="slider-benvenuto" class="owl-carousel owl-theme align-self-center">
                            <?php
                                $passo = 1; 
                                                    
                                $configurazioneColore  = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataCms");
                                if($configurazioneColore["logo"]=="template/logoGeecom.svg") {
                            ?>
                                    <div class="item">
                                        <i class="fas fa-palette fa-3x mb-3 text-primary"></i>
                                        <h5>Passo <?php echo $passo; ?>: carica il tuo logo</h5>
                                        <p>Carica il tuo logo. Vai nelle <b>Impostazioni</b>, clicca su <b>Aspetto</b> e carica il tuo logo </p>
                                        <a class="btn btn-outline-primary btn-sm" href="impostazioni.php">Impostazioni</a>
                                    </div>
                            <?php
                                    $passo++;
                                }
                               
                                $numeroContenuti = $geecomDb->contaRigheTabella("geecB_contenuti");
                                if($numeroContenuti==12) { // questo avviso viene mostrato se l'utente non ha creato alcun contenuto
                            ?>
                                    <div class="item">
                                        <i class="fas fa-pen-square fa-3x mb-3 text-primary"></i>
                                        <h5>Passo <?php echo $passo; ?>: crea il tuo primo contenuto</h5>
                                        <p>Non hai ancora creato contenuti! Comincia a creare con Geecom </p>
                                        <a class="btn btn-outline-primary btn-sm" href="../controller/controllerContenuti.php?operazione=creaArticolo">Crea articolo</a>
                                        <a class="btn btn-outline-primary btn-sm" href="creaContenuto.php?tipo=pagina">Crea pagina</a>
                                    </div>
                            <?php
                                
                                    $passo++;
                                }
                                
                                $datiPaginaChiSiamo  = $geecomDb->leggiSingolaRiga("geecB_contenuti", 3);
                                if($datiPaginaChiSiamo["dataCreazione"]==$datiPaginaChiSiamo["dataUltimaModifica"]) {
                            ?>
                                    <div class="item">
                                        <i class="fas fa-id-badge fa-3x mb-3 text-primary"></i>
                                        <h5>Passo <?php echo $passo; ?>: personalizza la pagina Chi siamo</h5>
                                        <p>Modifica la tua pagina <a href="creaContenuto.php?id=3"><b>Chi siamo</b></a> raccontando la tua storia</p>
                                        <a class="btn btn-outline-primary btn-sm" href="creaContenuto.php?id=3">Modifica la pagina</a>
                                    </div>
                            <?php
                                    $passo++;
                                }
                                
                                $datiPaginaContatti  = $geecomDb->leggiSingolaRiga("geecB_contenuti", 5);
                                if($datiPaginaContatti["dataCreazione"]==$datiPaginaContatti["dataUltimaModifica"]) {
                            ?>
                                    <div class="item">
                                        <i class="fas fa-address-book fa-3x mb-3 text-primary"></i>
                                        <h5>Passo <?php echo $passo; ?>: personalizza la pagina Contatti</h5>
                                        <p>Modifica la tua pagina <a href="creaContenuto.php?id=5"><b>Contatti</b></a> inserendo i dati per farti contattare.</p>
                                        <a class="btn btn-outline-primary btn-sm" href="creaContenuto.php?id=5">Modifica la pagina</a>
                                    </div>
                            <?php
                                    $passo++;
                                }
                                
                                $datiPaginaPrivacy  = $geecomDb->leggiSingolaRiga("geecB_contenuti", 4);
                                if($datiPaginaPrivacy["dataCreazione"]==$datiPaginaPrivacy["dataUltimaModifica"]) {
                            ?>
                                    <div class="item">
                                        <i class="fas fa-cookie fa-3x mb-3 text-primary"></i>
                                        <h5>Passo <?php echo $passo; ?>: personalizza la tua informativa sulla privacy</h5>
                                        <p>La pagina <a href="creaContenuto.php?id=4"><b>Informativa sulla privacy</b></a> è ancora quella generata in automatico, controlla se va bene!</p>
                                        <a class="btn btn-outline-primary btn-sm" href="creaContenuto.php?id=4">Modifica la pagina</a>
                                    </div>
                            <?php
                            
                                    $passo++;
                                }
                                
                                if($impostazioni["reindirizzamentoHttps"]=="nessuno") {
                            ?>
                                    <div class="item">
                                        <i class="fas fa-shield-alt fa-3x mb-3 text-primary"></i>
                                        <h5>Passo <?php echo $passo; ?>: attiva HTTPS</h5>
                                        <p>Avere la connessione sicura in HTTPS è importante per la sicurezza e per i motori di ricerca. Assicurati di avere il certificato HTTPS e poi vai in impostazioni -> sicurezza e clicca su attiva l'HTTPS  </p>
                                        <a class="btn btn-outline-primary btn-sm" href="impostazioni.php">Impostazioni</a>
                                    </div>
                            <?php
                                }
                            ?>
                        </div>
                </div>
            </div>
        </div>
        <div class="card-footer">
            <a href="../controller/controllerImpostazioni.php?operazione=disattivaGuidaIniziale" class="btn btn-outline-primary btn-sm float-right"><i class="fas fa-times mr-2"></i>Non mostrare più</a>
        </div>
    </div>